/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.
	
	$Id: pgpRPCMsg.h,v 1.55.2.4 2001/08/16 21:23:39 pbj Exp $
____________________________________________________________________________*/

/* NOTE: CHANGES TO THE INTERFACE SHOULD INCREMENT PGPMSG_PROTOCOL_REV */

#ifndef Included_pgpRPCMsg_h	/* [ */
#define Included_pgpRPCMsg_h

#include "pgpPubTypes.h"
#include "pgpFileSpec.h"

enum PGPPackMsgType_
{
	kPGP_Connect_MSG,
	kPGP_FetchObjectData_MSG,
	kPGP_GetKeyByKeyID_MSG,
	kPGP_KeyEncrypt_MSG,
	kPGP_KeyDecrypt_MSG,
	kPGP_KeyVerify_MSG,
	kPGP_KeySign_MSG,
	kPGP_SecPassphraseOK_MSG,
	kPGP_KeyMaxSizes_MSG,
	kPGP_SecProperties_MSG,
	kPGP_FetchKeyInfo_MSG,
	kPGP_OpenKeyDBFile_MSG,
	kPGP_ImportKeyBinary_MSG,
	kPGP_KeyDBFlush_MSG,
	kPGP_FreeKeyDB_MSG,
	kPGP_SetKeyEnabled_MSG,
	kPGP_SetKeyAxiomatic_MSG,
	kPGP_PropagateTrust_MSG,
	kPGP_CheckKeyRingSigs_MSG,
	kPGP_PrepareToCheckKeyRingSigs_MSG,
	kPGP_CheckSig_MSG,
	kPGP_DoGenerateKey_MSG,
	kPGP_AddUserID_MSG,
	kPGP_CertifyUserID_MSG,
	kPGP_CertifyPrimaryUserID_MSG,
	kPGP_RevokeSig_MSG,
	kPGP_RevokeKey_MSG,
	kPGP_DoChangePassphrase_MSG,
	kPGP_PassphraseIsValid_MSG,
	kPGP_SetKeyTrust_MSG,
	kPGP_GetPasskeyBuffer_MSG,
	kPGP_AddKeyOptions_MSG,
	kPGP_UpdateKeyOptions_MSG,
	kPGP_KeyDBAddObject_MSG,
	kPGP_KeyDBRemoveObject_MSG,
	kPGP_NewKeyDB_MSG,
	kPGP_KeyDBArray_MSG,
	kPGP_GlobalRandomPoolAddState_MSG,
	kPGP_GlobalRandomPoolGetInfo_MSG,
	kPGP_RandomGetBytesEntropy_MSG,
	kPGP_UpdateKeyDB_MSG,
	kPGP_RandomAddBytes_MSG,
	kPGP_PurgePassphraseCache_MSG,
	kPGP_CopyKeys_MSG,
	kPGP_SetRandSeedFile_MSG,
	kPGP_Disconnect_MSG,
	kPGP_Reconnect_MSG,
	kPGP_RandomStir_MSG,
	kPGP_CreateKeypair_MSG,
	kPGP_CreateSubkeypair_MSG,
	kPGP_CountTokens_MSG,
	kPGP_GetTokenInfo_MSG,
	kPGP_CopyKeyToToken_MSG,
	kPGP_DeleteKeyOnToken_MSG,
	kPGP_WipeToken_MSG,
	kPGP_TokenPassphraseIsValid_MSG,
    kPGP_TokenImportX509_MSG, 
    kPGP_TokenPutKeyContainer_MSG,
	kPGP_TokenGetKeyContainer_MSG,
    kPGP_SetPKCS11DrvFile_MSG, 

	PGP_ENUM_FORCE( PGPPackMsgType_ )
};
PGPENUM_TYPEDEF( PGPPackMsgType_, PGPPackMsgType);

typedef struct PGPPackMsg
{
	PGPInt32 type;
	PGPInt32 length;
	PGPInt32 ptr;
	PGPInt32 svc_id;
	PGPInt32 status;
	PGPUInt32 connect_ref;
	PGPByte *base;
} PGPPackMsg;

typedef struct pgpRPCconnection
{
#if PGP_WIN32
	PGPUInt32 EventHandle;	// handle of event used to signal frontend
#else
	PGPUInt32 ThreadID;
#endif
	PGPByte *UserName;
#if PGP_UNIX
	int uid, gid, pid;
#endif
} pgpRPCconnection;

extern PGPContextRef gCtx;
#define PGPMSG_PROTOCOL_REV		215

PGP_BEGIN_C_DECLARATIONS

#if PGP_WIN32

void			pgpSDKFrontEndSetTimer();
PGPUInt32		pgpSDKGetFrontEndEventHandle();
PGPBoolean		PGPIsInitRPCBuf(char *ptr);
void			PGPGetRPCInitBuf(void **base, int *len);

#elif PGP_UNIX

void			pgpRPCGetUnixClientAuth(pgpRPCconnection *);
PGPBoolean		pgpRPCVerifyUnixClientAuth(pgpRPCconnection *);

#endif

#if PGP_MACINTOSH && PGPSDK_BACKEND
#pragma export on
#endif
PGPError		pgpConnect_backRPC(void);
PGPError		pgpDisconnect_backRPC(void);
PGPError		pgpReconnect_backRPC(void);
#if PGP_MACINTOSH && PGPSDK_BACKEND
#pragma export off
#endif
PGPBoolean		pgpRPCEnabled();
void			pgpInitFrontEndThread(PGPBoolean ClientSidePwdCache);
void			pgpKillFrontEndThread();
void			pgpRPCCreateBEContext();
void			pgpNotifyClient(PGPUInt32 connectref, PGPUInt32 lParam);
PGPInt32		pgpRPCSendPacket(PGPPackMsg *pkt, PGPPackMsg *rpkt, PGPBoolean okayToBlock);
PGPError		pgpRPCInit();
void			pgpRPCUninit();
void			pack_init(PGPPackMsg *pkt, PGPInt32 type, PGPInt32 connection_ref);
void			pack_init_secure(PGPPackMsg *pkt, PGPInt32 type, PGPInt32 connection_ref);
void			pack_opaque(PGPPackMsg *pkt, const void *base, PGPSize len);
void			unpack_opaque(PGPPackMsg *pkt, void **base, PGPSize *len);
void			unpack_opaque_alloc(PGPPackMsg *pkt, void **base, PGPSize *len);
void			unpack_opaque_secure(PGPPackMsg *pkt, void **base, PGPSize *len);
void			pack_int32(PGPPackMsg *pkt, PGPInt32 num);
PGPInt32		unpack_int32(PGPPackMsg *pkt);
void			pack_uint32(PGPPackMsg *, PGPUInt32);
PGPUInt32		unpack_uint32(PGPPackMsg *);
void			pack_filespec(PGPPackMsg *pkt, PFLFileSpecRef file);
PFLFileSpecRef	unpack_filespec(PGPPackMsg *pkt, PGPMemoryMgrRef mem_mgr);
void			pack_bool(PGPPackMsg *pkt, PGPBoolean num);
PGPBoolean		unpack_bool(PGPPackMsg *pkt);
void			pack_byte(PGPPackMsg *pkt, PGPByte num);
PGPByte			unpack_byte(PGPPackMsg *pkt);
void rcv_generic(PGPByte buf[], PGPSize inlen, PGPByte *outbuf[], PGPSize *outlen);
PGPUInt32		pgpRPCAllocConnection();
void			pgpRPCServerShuttingDown();

PGP_END_C_DECLARATIONS

#endif	/* ] Included_pgpRPCMsg_h */

/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
